#Chapter 8 Correlation / OLS

wtd.cor(cbind(states$attend.pct,states$college,states$womleg.2010))

#regression with unweighted data
summary(lm(womleg.2010~attend.pct,data=states))
summary(lm(womleg.2010~college,   data=states))
#note tweaks on cex (size of symbols) and pch=symbol type
#default pch is 1, no-fill circles
scatterplot(womleg.2010~college, data=states,
  reg.line=lm,
  #lty=1, default line type
  #lwd=1, default line width
  col="black",
  smooth=FALSE, 
  boxplots=FALSE, 
  xlab="Percent college or higher", 
  ylab="Percent state legislators who are women",
  main="Percent Female State Legislators, \n by Percent Population College or Higher",
  pch=16,
  font.main=1)
#In symbols, set add=T to add circles representing attend.pct to existing scatter

symbols(states$college,states$womleg.2010,

  add=T,

  circle=states$attend.pct,

  inches=0.25,

  fg="black", 

  bg=416)

#To label bubbles with state names:
text(states$college,states$womleg.2010,states$state, cex=.6)

#Type colors() or colours() to see names of all R colors
#colors can be referenced by number as well as name: col=1 is the same as col="white"
#Local function: RColors() produces the Glynn graph from following link
#See this link for more information on R colors
#http://research.stowers-institute.org/efg/R/Color/Chart/

summary(lm(womleg.2010~college,data=states))

summary(lm(womleg.2010~college+attend.pct,data=states))

#weighted data
wtd.cor(cbind(nes$fed.spend,nes$dem.therm,nes$income.rn),weight=nes$wt)

nesD=svydesign(id=~1,data=nes,weights=~wt)

summary(svyglm(fed.spend~dem.therm,design=nesD,na.action=na.omit))
        svyglm(fed.spend~dem.therm,design=nesD,na.action=na.omit)
AdjR2(2008,174600,152200,1)

summary(svyglm(fed.spend~dem.therm + income.rn,design=nesD,na.action=na.omit))
        svyglm(fed.spend~dem.therm + income.rn,design=nesD,na.action=na.omit)
AdjR2(1900,164700,140600,2)
#Discuss svyplot, style="hex" in a Box
#svyplot(fed.spend~dem.therm,design=nesD, style="grayhex", legend=0)
#legend=0 suppresses the legend
svyplot(fed.spend~dem.therm,design=nesD, style="hex", legend=0,
 xlab="Rating of Democratic Party", 
 ylab="Federal Spending Scale",
  main="Opposition to Federal Spending, \n by Rating of the Democratic Party")

svyplot(fed.spend~dem.therm,design=nesD, style="grayhex", legend=0,
 xlab="Rating of Democratic Party", 
 ylab="Federal Spending Scale",
  main="Opposition to Federal Spending, \n by Rating of the Democratic Party")

#Different possiblities for graphs with svy (see Lumley, begin on p67)
svyplot(obama.therm~dem.therm,design=nesD, style="bubble")
svyplot(obama.therm~dem.therm,design=nesD, style="transparent",
  pch=19, alpha=c(0,0.5))
svyplot(fed.spend~dem.therm,design=nesD, style="subsample", sample.size=150,
  xlab="Rating of Democratic Party", ylab="Federal Spending Scale",
  main="Opposition to Federal Spending, by Rating of the Democratic Party",
  font.main=1)
svyplot(gay.therm~educ.r,design=nesD, style="subsample", sample.size=150,
  xlab="Rating of Democratic Party", ylab="Rating of Obama",
  main="Rating of Obama, by Rating of the Democratic Party",
  font.main=1)

#library(hexbin)
#AdjR2(Total df,null deviance, residual deviance, #IVs in model)


#Exercise 1: states: dem.hr09, demstate09, union07
wtd.cor(cbind(states$dem.hr09, states$demstate09, states$union07))

#Exercise 2: states: cons.hr09, conpct.m
summary(lm(states$cons.hr09~states$conpct.m))
scatterplot(cons.hr09~conpct.m, data=states,
  reg.line=lm, col="black",
  smooth=FALSE, 
  boxplots=FALSE, 
  main="Congressional Conservatismm Scores,\n by Percent Mass Public Conservative",
  xlab="Percent Mass Public 'Conservative'", 
  ylab="Conservative Votes, House Delegation", pch=16, font.main=1)

#Exercise 3: states: to.0408, obama08
summary(lm(states$obama08~states$to.0408))

#Exercise 4: states: abortlaw, permit, womleg.2010
#wtd.cor(cbind(states$abortlaw, states$permit, states$womleg.2010))
summary(lm(states$abortlaw~states$permit))
scatterplot(abortlaw~permit, data=states,
  reg.line=lm, col="black",
  main="Number of Abortion Restrictions, \n by Percent Mass Public Pro-Choice",
  smooth=FALSE,  
  boxplots=FALSE, 
  xlab="Percent Mass Public 'Always permit' Abortion", 
  ylab="Number of Abortion Restrictions", pch=16, font.main=1)

symbols(states$abortlaw~states$permit,
  add=T,
  circle=states$womleg.2010,
  inches=0.25,
  fg="black", 
  bg=416)
summary(lm(states$abortlaw~states$permit+states$womleg.2010))

#Exercise 5: states: demstate09, dempct.m, libpct.m
wtd.cor(cbind(states$demstate09, states$dempct.m, states$libpct.m))
summary(lm(states$demstate09~states$dempct.m+states$libpct.m))

#Exercise 6: gssD: fem.role, age, authoritarianism

#gssD=svydesign(id=~1,data=gss,weights=~wtss)
#wtd.cor(cbind(gss$fem.role,gss$age,gss$authoritarianism), weight=gss$wtss)

summary(svyglm(fem.role~age,design=gssD,na.action=na.omit))
        svyglm(fem.role~age,design=gssD,na.action=na.omit)
AdjR2(1281,4864,4724,1)
summary(svyglm(fem.role~age + authoritarianism,design=gssD,na.action=na.omit))
        svyglm(fem.role~age + authoritarianism,design=gssD,na.action=na.omit)
AdjR2(642,2457,2300,2)

svyplot(fem.role~age,design=gssD, style="hex", legend=0,
 xlab="Age", 
 ylab="Support for Non-Traditional Gender Roles",
  main="Gender Role Attitudes, by Age")



